#!/bin/bash
# Monitoring script for UltraWhisper Proxy

# Colors for output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

clear

echo "=== UltraWhisper Proxy Monitor ==="
echo "Press Ctrl+C to exit"
echo

while true; do
    # Clear previous output
    printf "\033[5A"  # Move cursor up 5 lines
    
    # Get current time
    echo "📅 $(date '+%Y-%m-%d %H:%M:%S')"
    echo
    
    # Check NGINX health
    nginx_status=$(curl -s http://localhost:8080/health 2>/dev/null)
    if [ $? -eq 0 ]; then
        status=$(echo $nginx_status | jq -r '.status' 2>/dev/null || echo "unknown")
        has_keys=$(echo $nginx_status | jq -r '.keys' 2>/dev/null || echo "false")
        
        if [ "$status" == "healthy" ]; then
            echo -e "${GREEN}✅ NGINX: Healthy${NC}"
        elif [ "$status" == "degraded" ]; then
            echo -e "${YELLOW}⚠️  NGINX: Degraded (keys: $has_keys)${NC}"
        else
            echo -e "${RED}❌ NGINX: Unhealthy${NC}"
        fi
    else
        echo -e "${RED}❌ NGINX: Not responding${NC}"
    fi
    
    # Check Sync Service
    sync_status=$(curl -s http://localhost:8081/status 2>/dev/null)
    if [ $? -eq 0 ]; then
        healthy=$(echo $sync_status | jq -r '.healthy' 2>/dev/null || echo "false")
        last_sync=$(echo $sync_status | jq -r '.last_sync' 2>/dev/null || echo "never")
        api_keys=$(echo $sync_status | jq -r '.api_keys_loaded' 2>/dev/null || echo "0")
        
        if [ "$healthy" == "true" ]; then
            echo -e "${GREEN}✅ Sync: Healthy (${api_keys} keys, last: ${last_sync:11:8})${NC}"
        else
            error=$(echo $sync_status | jq -r '.last_error' 2>/dev/null || echo "unknown")
            echo -e "${RED}❌ Sync: Error - $error${NC}"
        fi
    else
        echo -e "${RED}❌ Sync: Not responding${NC}"
    fi
    
    # Check Redis
    redis_ping=$(docker exec models-redis redis-cli ping 2>/dev/null)
    if [ "$redis_ping" == "PONG" ]; then
        echo -e "${GREEN}✅ Redis: Connected${NC}"
    else
        echo -e "${RED}❌ Redis: Not responding${NC}"
    fi
    
    # Show recent logs (errors only)
    echo
    echo "📋 Recent Errors:"
    docker-compose logs --tail=5 2>&1 | grep -E "ERROR|CRITICAL|Failed" | tail -3 || echo "  No recent errors"
    
    sleep 5
done